/*! Hammer.JS - v1.1.3 - 2014-05-20
 * http://eightmedia.github.io/hammer.js
 *
 * Copyright (c) 2014 Jorik Tangelder <j.tangelder@gmail.com>;
 * Licensed under the MIT license */
!function(e,t){"use strict";function n(){i.READY||(y.determineEventTypes(),m.each(i.gestures,function(e){b.register(e)}),y.onTouch(i.DOCUMENT,p,b.detect),y.onTouch(i.DOCUMENT,f,b.detect),i.READY=!0)}var i=function T(e,t){return new T.Instance(e,t||{})};i.VERSION="1.1.3",i.defaults={behavior:{userSelect:"none",touchAction:"pan-y",touchCallout:"none",contentZooming:"none",userDrag:"none",tapHighlightColor:"rgba(0,0,0,0)"}},i.DOCUMENT=document,i.HAS_POINTEREVENTS=navigator.pointerEnabled||navigator.msPointerEnabled,i.HAS_TOUCHEVENTS="ontouchstart"in e,i.IS_MOBILE=/mobile|tablet|ip(ad|hone|od)|android|silk/i.test(navigator.userAgent),i.NO_MOUSEEVENTS=i.HAS_TOUCHEVENTS&&i.IS_MOBILE||i.HAS_POINTEREVENTS,i.CALCULATE_INTERVAL=25;var o={},r=i.DIRECTION_DOWN="down",a=i.DIRECTION_LEFT="left",s=i.DIRECTION_UP="up",c=i.DIRECTION_RIGHT="right",l=i.POINTER_MOUSE="mouse",u=i.POINTER_TOUCH="touch",h=i.POINTER_PEN="pen",d=i.EVENT_START="start",p=i.EVENT_MOVE="move",f=i.EVENT_END="end",g=i.EVENT_RELEASE="release",v=i.EVENT_TOUCH="touch";i.READY=!1,i.plugins=i.plugins||{},i.gestures=i.gestures||{};var m=i.utils={extend:function(e,n,i){for(var o in n)!n.hasOwnProperty(o)||e[o]!==t&&i||(e[o]=n[o]);return e},on:function(e,t,n){e.addEventListener(t,n,!1)},off:function(e,t,n){e.removeEventListener(t,n,!1)},each:function(e,n,i){var o,r;if("forEach"in e)e.forEach(n,i);else if(e.length!==t){for(o=0,r=e.length;r>o;o++)if(n.call(i,e[o],o,e)===!1)return}else for(o in e)if(e.hasOwnProperty(o)&&n.call(i,e[o],o,e)===!1)return},inStr:function(e,t){return e.indexOf(t)>-1},inArray:function(e,t){if(e.indexOf){var n=e.indexOf(t);return-1===n?!1:n}for(var i=0,o=e.length;o>i;i++)if(e[i]===t)return i;return!1},toArray:function(e){return Array.prototype.slice.call(e,0)},hasParent:function(e,t){for(;e;){if(e==t)return!0;e=e.parentNode}return!1},getCenter:function(e){var t=[],n=[],i=[],o=[],r=Math.min,a=Math.max;return 1===e.length?{pageX:e[0].pageX,pageY:e[0].pageY,clientX:e[0].clientX,clientY:e[0].clientY}:(m.each(e,function(e){t.push(e.pageX),n.push(e.pageY),i.push(e.clientX),o.push(e.clientY)}),{pageX:(r.apply(Math,t)+a.apply(Math,t))/2,pageY:(r.apply(Math,n)+a.apply(Math,n))/2,clientX:(r.apply(Math,i)+a.apply(Math,i))/2,clientY:(r.apply(Math,o)+a.apply(Math,o))/2})},getVelocity:function(e,t,n){return{x:Math.abs(t/e)||0,y:Math.abs(n/e)||0}},getAngle:function(e,t){var n=t.clientX-e.clientX,i=t.clientY-e.clientY;return 180*Math.atan2(i,n)/Math.PI},getDirection:function(e,t){var n=Math.abs(e.clientX-t.clientX),i=Math.abs(e.clientY-t.clientY);return n>=i?e.clientX-t.clientX>0?a:c:e.clientY-t.clientY>0?s:r},getDistance:function(e,t){var n=t.clientX-e.clientX,i=t.clientY-e.clientY;return Math.sqrt(n*n+i*i)},getScale:function(e,t){return e.length>=2&&t.length>=2?this.getDistance(t[0],t[1])/this.getDistance(e[0],e[1]):1},getRotation:function(e,t){return e.length>=2&&t.length>=2?this.getAngle(t[1],t[0])-this.getAngle(e[1],e[0]):0},isVertical:function(e){return e==s||e==r},setPrefixedCss:function(e,t,n,i){var o=["","Webkit","Moz","O","ms"];t=m.toCamelCase(t);for(var r=0;r<o.length;r++){var a=t;if(o[r]&&(a=o[r]+a.slice(0,1).toUpperCase()+a.slice(1)),a in e.style){e.style[a]=(null==i||i)&&n||"";break}}},toggleBehavior:function(e,t,n){if(t&&e&&e.style){m.each(t,function(t,i){m.setPrefixedCss(e,i,t,n)});var i=n&&function(){return!1};"none"==t.userSelect&&(e.onselectstart=i),"none"==t.userDrag&&(e.ondragstart=i)}},toCamelCase:function(e){return e.replace(/[_-]([a-z])/g,function(e){return e[1].toUpperCase()})}},y=i.event={preventMouseEvents:!1,started:!1,shouldDetect:!1,on:function(e,t,n,i){var o=t.split(" ");m.each(o,function(t){m.on(e,t,n),i&&i(t)})},off:function(e,t,n,i){var o=t.split(" ");m.each(o,function(t){m.off(e,t,n),i&&i(t)})},onTouch:function(e,t,n){var r=this,a=function(o){var a,s=o.type.toLowerCase(),c=i.HAS_POINTEREVENTS,l=m.inStr(s,"mouse");l&&r.preventMouseEvents||(l&&t==d&&0===o.button?(r.preventMouseEvents=!1,r.shouldDetect=!0):c&&t==d?r.shouldDetect=1===o.buttons||w.matchType(u,o):l||t!=d||(r.preventMouseEvents=!0,r.shouldDetect=!0),c&&t!=f&&w.updatePointer(t,o),r.shouldDetect&&(a=r.doDetect.call(r,o,t,e,n)),a==f&&(r.preventMouseEvents=!1,r.shouldDetect=!1,w.reset()),c&&t==f&&w.updatePointer(t,o))};return this.on(e,o[t],a),a},doDetect:function(e,t,n,i){var o=this.getTouchList(e,t),r=o.length,a=t,s=o.trigger,c=r;t==d?s=v:t==f&&(s=g,c=o.length-(e.changedTouches?e.changedTouches.length:1)),c>0&&this.started&&(a=p),this.started=!0;var l=this.collectEventData(n,a,o,e);return t!=f&&i.call(b,l),s&&(l.changedLength=c,l.eventType=s,i.call(b,l),l.eventType=a,delete l.changedLength),a==f&&(i.call(b,l),this.started=!1),a},determineEventTypes:function(){var t;return t=i.HAS_POINTEREVENTS?e.PointerEvent?["pointerdown","pointermove","pointerup pointercancel lostpointercapture"]:["MSPointerDown","MSPointerMove","MSPointerUp MSPointerCancel MSLostPointerCapture"]:i.NO_MOUSEEVENTS?["touchstart","touchmove","touchend touchcancel"]:["touchstart mousedown","touchmove mousemove","touchend touchcancel mouseup"],o[d]=t[0],o[p]=t[1],o[f]=t[2],o},getTouchList:function(e,t){if(i.HAS_POINTEREVENTS)return w.getTouchList();if(e.touches){if(t==p)return e.touches;var n=[],o=[].concat(m.toArray(e.touches),m.toArray(e.changedTouches)),r=[];return m.each(o,function(e){m.inArray(n,e.identifier)===!1&&r.push(e),n.push(e.identifier)}),r}return e.identifier=1,[e]},collectEventData:function(e,t,n,i){var o=u;return m.inStr(i.type,"mouse")||w.matchType(l,i)?o=l:w.matchType(h,i)&&(o=h),{center:m.getCenter(n),timeStamp:Date.now(),target:i.target,touches:n,eventType:t,pointerType:o,srcEvent:i,preventDefault:function(){var e=this.srcEvent;e.preventManipulation&&e.preventManipulation(),e.preventDefault&&e.preventDefault()},stopPropagation:function(){this.srcEvent.stopPropagation()},stopDetect:function(){return b.stopDetect()}}}},w=i.PointerEvent={pointers:{},getTouchList:function(){var e=[];return m.each(this.pointers,function(t){e.push(t)}),e},updatePointer:function(e,t){e==f||e!=f&&1!==t.buttons?delete this.pointers[t.pointerId]:(t.identifier=t.pointerId,this.pointers[t.pointerId]=t)},matchType:function(e,t){if(!t.pointerType)return!1;var n=t.pointerType,i={};return i[l]=n===(t.MSPOINTER_TYPE_MOUSE||l),i[u]=n===(t.MSPOINTER_TYPE_TOUCH||u),i[h]=n===(t.MSPOINTER_TYPE_PEN||h),i[e]},reset:function(){this.pointers={}}},b=i.detection={gestures:[],current:null,previous:null,stopped:!1,startDetect:function(e,t){this.current||(this.stopped=!1,this.current={inst:e,startEvent:m.extend({},t),lastEvent:!1,lastCalcEvent:!1,futureCalcEvent:!1,lastCalcData:{},name:""},this.detect(t))},detect:function(e){if(this.current&&!this.stopped){e=this.extendEventData(e);var t=this.current.inst,n=t.options;return m.each(this.gestures,function(i){!this.stopped&&t.enabled&&n[i.name]&&i.handler.call(i,e,t)},this),this.current&&(this.current.lastEvent=e),e.eventType==f&&this.stopDetect(),e}},stopDetect:function(){this.previous=m.extend({},this.current),this.current=null,this.stopped=!0},getCalculatedData:function(e,t,n,o,r){var a=this.current,s=!1,c=a.lastCalcEvent,l=a.lastCalcData;c&&e.timeStamp-c.timeStamp>i.CALCULATE_INTERVAL&&(t=c.center,n=e.timeStamp-c.timeStamp,o=e.center.clientX-c.center.clientX,r=e.center.clientY-c.center.clientY,s=!0),(e.eventType==v||e.eventType==g)&&(a.futureCalcEvent=e),(!a.lastCalcEvent||s)&&(l.velocity=m.getVelocity(n,o,r),l.angle=m.getAngle(t,e.center),l.direction=m.getDirection(t,e.center),a.lastCalcEvent=a.futureCalcEvent||e,a.futureCalcEvent=e),e.velocityX=l.velocity.x,e.velocityY=l.velocity.y,e.interimAngle=l.angle,e.interimDirection=l.direction},extendEventData:function(e){var t=this.current,n=t.startEvent,i=t.lastEvent||n;(e.eventType==v||e.eventType==g)&&(n.touches=[],m.each(e.touches,function(e){n.touches.push({clientX:e.clientX,clientY:e.clientY})}));var o=e.timeStamp-n.timeStamp,r=e.center.clientX-n.center.clientX,a=e.center.clientY-n.center.clientY;return this.getCalculatedData(e,i.center,o,r,a),m.extend(e,{startEvent:n,deltaTime:o,deltaX:r,deltaY:a,distance:m.getDistance(n.center,e.center),angle:m.getAngle(n.center,e.center),direction:m.getDirection(n.center,e.center),scale:m.getScale(n.touches,e.touches),rotation:m.getRotation(n.touches,e.touches)}),e},register:function(e){var n=e.defaults||{};return n[e.name]===t&&(n[e.name]=!0),m.extend(i.defaults,n,!0),e.index=e.index||1e3,this.gestures.push(e),this.gestures.sort(function(e,t){return e.index<t.index?-1:e.index>t.index?1:0}),this.gestures}};i.Instance=function(e,t){var o=this;n(),this.element=e,this.enabled=!0,m.each(t,function(e,n){delete t[n],t[m.toCamelCase(n)]=e}),this.options=m.extend(m.extend({},i.defaults),t||{}),this.options.behavior&&m.toggleBehavior(this.element,this.options.behavior,!0),this.eventStartHandler=y.onTouch(e,d,function(e){o.enabled&&e.eventType==d?b.startDetect(o,e):e.eventType==v&&b.detect(e)}),this.eventHandlers=[]},i.Instance.prototype={on:function(e,t){var n=this;return y.on(n.element,e,t,function(e){n.eventHandlers.push({gesture:e,handler:t})}),n},off:function(e,t){var n=this;return y.off(n.element,e,t,function(e){var i=m.inArray({gesture:e,handler:t});i!==!1&&n.eventHandlers.splice(i,1)}),n},trigger:function(e,t){t||(t={});var n=i.DOCUMENT.createEvent("Event");n.initEvent(e,!0,!0),n.gesture=t;var o=this.element;return m.hasParent(t.target,o)&&(o=t.target),o.dispatchEvent(n),this},enable:function(e){return this.enabled=e,this},dispose:function(){var e,t;for(m.toggleBehavior(this.element,this.options.behavior,!1),e=-1;t=this.eventHandlers[++e];)m.off(this.element,t.gesture,t.handler);return this.eventHandlers=[],y.off(this.element,o[d],this.eventStartHandler),null}},function(e){function t(t,i){var o=b.current;if(!(i.options.dragMaxTouches>0&&t.touches.length>i.options.dragMaxTouches))switch(t.eventType){case d:n=!1;break;case p:if(t.distance<i.options.dragMinDistance&&o.name!=e)return;var l=o.startEvent.center;if(o.name!=e&&(o.name=e,i.options.dragDistanceCorrection&&t.distance>0)){var u=Math.abs(i.options.dragMinDistance/t.distance);l.pageX+=t.deltaX*u,l.pageY+=t.deltaY*u,l.clientX+=t.deltaX*u,l.clientY+=t.deltaY*u,t=b.extendEventData(t)}(o.lastEvent.dragLockToAxis||i.options.dragLockToAxis&&i.options.dragLockMinDistance<=t.distance)&&(t.dragLockToAxis=!0);var h=o.lastEvent.direction;t.dragLockToAxis&&h!==t.direction&&(t.direction=m.isVertical(h)?t.deltaY<0?s:r:t.deltaX<0?a:c),n||(i.trigger(e+"start",t),n=!0),i.trigger(e,t),i.trigger(e+t.direction,t);var v=m.isVertical(t.direction);(i.options.dragBlockVertical&&v||i.options.dragBlockHorizontal&&!v)&&t.preventDefault();break;case g:n&&t.changedLength<=i.options.dragMaxTouches&&(i.trigger(e+"end",t),n=!1);break;case f:n=!1}}var n=!1;i.gestures.Drag={name:e,index:50,handler:t,defaults:{dragMinDistance:10,dragDistanceCorrection:!0,dragMaxTouches:1,dragBlockHorizontal:!1,dragBlockVertical:!1,dragLockToAxis:!1,dragLockMinDistance:25}}}("drag"),i.gestures.Gesture={name:"gesture",index:1337,handler:function(e,t){t.trigger(this.name,e)}},function(e){function t(t,i){var o=i.options,r=b.current;switch(t.eventType){case d:clearTimeout(n),r.name=e,n=setTimeout(function(){r&&r.name==e&&i.trigger(e,t)},o.holdTimeout);break;case p:t.distance>o.holdThreshold&&clearTimeout(n);break;case g:clearTimeout(n)}}var n;i.gestures.Hold={name:e,index:10,defaults:{holdTimeout:500,holdThreshold:2},handler:t}}("hold"),i.gestures.Release={name:"release",index:1/0,handler:function(e,t){e.eventType==g&&t.trigger(this.name,e)}},i.gestures.Swipe={name:"swipe",index:40,defaults:{swipeMinTouches:1,swipeMaxTouches:1,swipeVelocityX:.6,swipeVelocityY:.6},handler:function(e,t){if(e.eventType==g){var n=e.touches.length,i=t.options;if(n<i.swipeMinTouches||n>i.swipeMaxTouches)return;(e.velocityX>i.swipeVelocityX||e.velocityY>i.swipeVelocityY)&&(t.trigger(this.name,e),t.trigger(this.name+e.direction,e))}}},function(e){function t(t,i){var o,r,a=i.options,s=b.current,c=b.previous;switch(t.eventType){case d:n=!1;break;case p:n=n||t.distance>a.tapMaxDistance;break;case f:!m.inStr(t.srcEvent.type,"cancel")&&t.deltaTime<a.tapMaxTime&&!n&&(o=c&&c.lastEvent&&t.timeStamp-c.lastEvent.timeStamp,r=!1,c&&c.name==e&&o&&o<a.doubleTapInterval&&t.distance<a.doubleTapDistance&&(i.trigger("doubletap",t),r=!0),(!r||a.tapAlways)&&(s.name=e,i.trigger(s.name,t)))}}var n=!1;i.gestures.Tap={name:e,index:100,handler:t,defaults:{tapMaxTime:250,tapMaxDistance:10,tapAlways:!0,doubleTapDistance:20,doubleTapInterval:300}}}("tap"),i.gestures.Touch={name:"touch",index:-1/0,defaults:{preventDefault:!1,preventMouse:!1},handler:function(e,t){return t.options.preventMouse&&e.pointerType==l?void e.stopDetect():(t.options.preventDefault&&e.preventDefault(),void(e.eventType==v&&t.trigger("touch",e)))}},function(e){function t(t,i){switch(t.eventType){case d:n=!1;break;case p:if(t.touches.length<2)return;var o=Math.abs(1-t.scale),r=Math.abs(t.rotation);if(o<i.options.transformMinScale&&r<i.options.transformMinRotation)return;b.current.name=e,n||(i.trigger(e+"start",t),n=!0),i.trigger(e,t),r>i.options.transformMinRotation&&i.trigger("rotate",t),o>i.options.transformMinScale&&(i.trigger("pinch",t),i.trigger("pinch"+(t.scale<1?"in":"out"),t));break;case g:n&&t.changedLength<2&&(i.trigger(e+"end",t),n=!1)}}var n=!1;i.gestures.Transform={name:e,index:45,defaults:{transformMinScale:.01,transformMinRotation:1},handler:t}}("transform"),"function"==typeof define&&define.amd?define(function(){return i}):"undefined"!=typeof module&&module.exports?module.exports=i:e.Hammer=i}(window),/*!
 * jQuery Mousewheel 3.1.13
 *
 * Copyright 2015 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 */
!function(e){e(jQuery)}(function(e){function t(t){var a=t||window.event,s=c.call(arguments,1),l=0,h=0,d=0,p=0,f=0,g=0;if(t=e.event.fix(a),t.type="mousewheel","detail"in a&&(d=-1*a.detail),"wheelDelta"in a&&(d=a.wheelDelta),"wheelDeltaY"in a&&(d=a.wheelDeltaY),"wheelDeltaX"in a&&(h=-1*a.wheelDeltaX),"axis"in a&&a.axis===a.HORIZONTAL_AXIS&&(h=-1*d,d=0),l=0===d?h:d,"deltaY"in a&&(d=-1*a.deltaY,l=d),"deltaX"in a&&(h=a.deltaX,0===d&&(l=-1*h)),0!==d||0!==h){if(1===a.deltaMode){var v=e.data(this,"mousewheel-line-height");l*=v,d*=v,h*=v}else if(2===a.deltaMode){var m=e.data(this,"mousewheel-page-height");l*=m,d*=m,h*=m}if(p=Math.max(Math.abs(d),Math.abs(h)),(!r||r>p)&&(r=p,i(a,p)&&(r/=40)),i(a,p)&&(l/=40,h/=40,d/=40),l=Math[l>=1?"floor":"ceil"](l/r),h=Math[h>=1?"floor":"ceil"](h/r),d=Math[d>=1?"floor":"ceil"](d/r),u.settings.normalizeOffset&&this.getBoundingClientRect){var y=this.getBoundingClientRect();f=t.clientX-y.left,g=t.clientY-y.top}return t.deltaX=h,t.deltaY=d,t.deltaFactor=r,t.offsetX=f,t.offsetY=g,t.deltaMode=0,s.unshift(t,l,h,d),o&&clearTimeout(o),o=setTimeout(n,200),(e.event.dispatch||e.event.handle).apply(this,s)}}function n(){r=null}function i(e,t){return u.settings.adjustOldDeltas&&"mousewheel"===e.type&&t%120===0}var o,r,a=["wheel","mousewheel","DOMMouseScroll","MozMousePixelScroll"],s="onwheel"in document||document.documentMode>=9?["wheel"]:["mousewheel","DomMouseScroll","MozMousePixelScroll"],c=Array.prototype.slice;if(e.event.fixHooks)for(var l=a.length;l;)e.event.fixHooks[a[--l]]=e.event.mouseHooks;var u=e.event.special.mousewheel={version:"3.1.12",setup:function(){if(this.addEventListener)for(var n=s.length;n;)this.addEventListener(s[--n],t,!1);else this.onmousewheel=t;e.data(this,"mousewheel-line-height",u.getLineHeight(this)),e.data(this,"mousewheel-page-height",u.getPageHeight(this))},teardown:function(){if(this.removeEventListener)for(var n=s.length;n;)this.removeEventListener(s[--n],t,!1);else this.onmousewheel=null;e.removeData(this,"mousewheel-line-height"),e.removeData(this,"mousewheel-page-height")},getLineHeight:function(t){var n=e(t),i=n["offsetParent"in e.fn?"offsetParent":"parent"]();return i.length||(i=e("body")),parseInt(i.css("fontSize"),10)||parseInt(n.css("fontSize"),10)||16},getPageHeight:function(t){return e(t).height()},settings:{adjustOldDeltas:!0,normalizeOffset:!0}};e.fn.extend({mousewheel:function(e){return e?this.bind("mousewheel",e):this.trigger("mousewheel")},unmousewheel:function(e){return this.unbind("mousewheel",e)}})}),/*!
* qTip2 - Pretty powerful tooltips
* http://craigsworks.com/projects/qtip2/
*
* Version: nightly
* Copyright 2009-2010 Craig Michael Thompson - http://craigsworks.com
*
* Dual licensed under MIT or GPLv2 licenses
*   http://en.wikipedia.org/wiki/MIT_License
*   http://en.wikipedia.org/wiki/GNU_General_Public_License
*
* Date: Thu Aug 18 12:11:24 PDT 2011
*/
function(e,t,n){function i(t,n){var i,l,u,f,g,v=e(this),m=e(document.body),y=this===document?m:v,w=v.metadata?v.metadata(n.metadata):p,b="html5"===n.metadata.type&&w?w[n.metadata.name]:p,T=v.data(n.metadata.name||"qtipopts");try{T="string"==typeof T?new Function("return "+T)():T}catch(x){a("Unable to parse HTML5 attribute data: "+T)}if(f=e.extend(h,{},s.defaults,n,"object"==typeof T?r(T):p,r(b||w)),l=f.position,f.id=t,"boolean"==typeof f.content.text){if(u=v.attr(f.content.attr),f.content.attr===d||!u)return a("Unable to locate content for tooltip! Aborting render of tooltip on element: ",v),d;f.content.text=u}if(l.container===d&&(l.container=m),l.target===d&&(l.target=y),f.show.target===d&&(f.show.target=y),f.show.solo===h&&(f.show.solo=m),f.hide.target===d&&(f.hide.target=y),f.position.viewport===h&&(f.position.viewport=l.container),l.at=new c.Corner(l.at),l.my=new c.Corner(l.my),e.data(this,"qtip"))if(f.overwrite)v.qtip("destroy");else if(f.overwrite===d)return d;return f.suppress&&(g=e.attr(this,"title"))&&e(this).removeAttr("title").attr(M,g),i=new o(v,f,t,!!u),e.data(this,"qtip",i),v.bind("remove.qtip",function(){i.destroy()}),i}function o(i,o,a,E){function C(){var n=[o.show.target[0],o.hide.target[0],j.rendered&&k.tooltip[0],o.position.container[0],o.position.viewport[0],t,document];j.rendered?e([]).pushStack(e.grep(n,function(e){return"object"==typeof e})).unbind(V):o.show.target.unbind(V+"-create")}function D(){function n(e){R.is(":visible")&&j.reposition(e)}function r(e){return R.hasClass(m)?d:(clearTimeout(j.timers.inactive),void(j.timers.inactive=setTimeout(function(){j.hide(e)},o.hide.inactive)))}function c(t){if(R.hasClass(m)||z||_)return d;var n=e(t.relatedTarget||t.target),i=n.closest(y)[0]===R[0],r=n[0]===f.show[0];clearTimeout(j.timers.show),clearTimeout(j.timers.hide),"mouse"===p.target&&i||o.hide.fixed&&/mouse(out|leave|move)/.test(t.type)&&(i||r)?(t.preventDefault(),t.stopImmediatePropagation()):o.hide.delay>0?j.timers.hide=setTimeout(function(){j.hide(t)},o.hide.delay):j.hide(t)}function u(e){if(R.hasClass(m))return d;f.show.trigger("qtip-"+a+"-inactive"),clearTimeout(j.timers.show),clearTimeout(j.timers.hide);var t=function(){j.toggle(h,e)};o.show.delay>0?j.timers.show=setTimeout(t,o.show.delay):t()}var p=o.position,f={show:o.show.target,hide:o.hide.target,viewport:e(p.viewport),document:e(document),window:e(t)},g={show:e.trim(""+o.show.event).split(" "),hide:e.trim(""+o.hide.event).split(" ")},v=e.browser.msie&&6===parseInt(e.browser.version,10);R.bind("mouseenter"+V+" mouseleave"+V,function(e){var t="mouseenter"===e.type;t&&j.focus(e),R.toggleClass(T,t)}),o.hide.fixed&&(f.hide=f.hide.add(R),R.bind("mouseover"+V,function(){R.hasClass(m)||clearTimeout(j.timers.hide)})),/mouse(out|leave)/i.test(o.hide.event)?"window"===o.hide.leave&&f.window.bind("mouseout"+V,function(e){/select|option/.test(e.target)&&!e.relatedTarget&&j.hide(e)}):/mouse(over|enter)/i.test(o.show.event)&&f.hide.bind("mouseleave"+V,function(){clearTimeout(j.timers.show)}),(""+o.hide.event).indexOf("unfocus")>-1&&f.document.bind("mousedown"+V,function(t){{var n=e(t.target);!R.hasClass(m)&&R.is(":visible")}n[0]!==R[0]&&0===n.parents(y).length&&n.add(i).length>1&&j.hide(t)}),"number"==typeof o.hide.inactive&&(f.show.bind("qtip-"+a+"-inactive",r),e.each(s.inactiveEvents,function(e,t){f.hide.add(k.tooltip).bind(t+V+"-inactive",r)})),e.each(g.hide,function(t,n){var i=e.inArray(n,g.show),o=e(f.hide);i>-1&&o.add(f.show).length===o.length||"unfocus"===n?(f.show.bind(n+V,function(e){R.is(":visible")?c(e):u(e)}),delete g.show[i]):f.hide.bind(n+V,c)}),e.each(g.show,function(e,t){f.show.bind(t+V,u)}),"number"==typeof o.hide.distance&&f.show.add(R).bind("mousemove"+V,function(e){var t=N.origin||{},n=o.hide.distance,i=Math.abs;(i(e.pageX-t.pageX)>=n||i(e.pageY-t.pageY)>=n)&&j.hide(e)}),"mouse"===p.target&&(f.show.bind("mousemove"+V,function(e){l={pageX:e.pageX,pageY:e.pageY,type:"mousemove"}}),p.adjust.mouse&&(o.hide.event&&R.bind("mouseleave"+V,function(e){(e.relatedTarget||e.target)!==f.show[0]&&j.hide(e)}),f.document.bind("mousemove"+V,function(e){!R.hasClass(m)&&R.is(":visible")&&j.reposition(e||l)}))),(p.adjust.resize||f.viewport.length)&&(e.event.special.resize?f.viewport:f.window).bind("resize"+V,n),(f.viewport.length||v&&"fixed"===R.css("position"))&&f.viewport.bind("scroll"+V,n)}function S(t,o){function r(t){function i(n){n&&(delete s[n.src],clearTimeout(j.timers.img[n.src]),e(n).unbind(V)),e.isEmptyObject(s)&&(j.redraw(),o!==d&&j.reposition(N.event),t())}var r,s={};return 0===(r=a.find("img:not([height]):not([width])")).length?i():void r.each(function(t,o){s[o.src]===n&&(function r(){return o.height||o.width?i(o):void(j.timers.img[o.src]=setTimeout(r,700))}(),e(o).bind("error"+V+" load"+V,function(){i(this)}),s[o.src]=o)})}var a=k.content;return j.rendered&&t?(e.isFunction(t)&&(t=t.call(i,N.event,j)||""),t.jquery&&t.length>0?a.empty().append(t.css({display:"block"})):a.html(t),j.rendered<0?R.queue("fx",r):(_=0,r(e.noop)),j):d}function O(t,n){var o=k.title;return j.rendered&&t?(e.isFunction(t)&&(t=t.call(i,N.event,j)),t===d?I(d):(t.jquery&&t.length>0?o.empty().append(t.css({display:"block"})):o.html(t),j.redraw(),n!==d&&j.rendered&&R.is(":visible")&&j.reposition(N.event),void 0)):d}function X(e){var t=k.button,n=k.title;return j.rendered?void(e?(n||Y(),A()):t.remove()):d}function Y(){var t=H+"-title";k.titlebar&&I(),k.titlebar=e("<div />",{"class":g+"-titlebar "+(o.style.widget?"ui-widget-header":"")}).append(k.title=e("<div />",{id:t,"class":g+"-title"})).insertBefore(k.content),o.content.title.button?A():j.rendered&&j.redraw()}function A(){var t=o.content.title.button,n="string"==typeof t,i=n?t:"Close tooltip";k.button&&k.button.remove(),k.button=t.jquery?t:e("<a />",{"class":"ui-state-default "+(o.style.widget?"":g+"-icon"),title:i,"aria-label":i}).prepend(e("<span />",{"class":"ui-icon ui-icon-close",html:"&times;"})),k.button.appendTo(k.titlebar).attr("role","button").hover(function(t){e(this).toggleClass("ui-state-hover","mouseenter"===t.type)}).click(function(e){return R.hasClass(m)||j.hide(e),d}).bind("mousedown keydown mouseup keyup mouseout",function(t){e(this).toggleClass("ui-state-active ui-state-focus","down"===t.type.substr(-4))}),j.redraw()}function I(e){k.title&&(k.titlebar.remove(),k.titlebar=k.title=k.button=p,e!==d&&j.reposition())}function L(){var e=o.style.widget;R.toggleClass(v,e).toggleClass(w,!e),k.content.toggleClass(v+"-content",e),k.titlebar&&k.titlebar.toggleClass(v+"-header",e),k.button&&k.button.toggleClass(g+"-icon",!e)}function P(e){for(var t,n=0,i=o,r=e.split(".");i=i[r[n++]];)n<r.length&&(t=i);return[t||o,r.pop()]}var k,N,j=this,q=document.body,H=g+"-"+a,z=0,_=0,R=e(),V=".qtip-"+a;j.id=a,j.rendered=d,j.elements=k={target:i},j.timers={img:{}},j.options=o,j.checks={},j.plugins={},j.cache=N={event:{},target:e(),disabled:d,attr:E},j.checks.builtin={"^id$":function(t,n,i){var o=i===h?s.nextid:i,r=g+"-"+o;o!==d&&o.length>0&&!e("#"+r).length&&(R[0].id=r,k.content[0].id=r+"-content",k.title[0].id=r+"-title")},"^content.text$":function(e,t,n){S(n)},"^content.title.text$":function(e,t,n){return n?(!k.title&&n&&Y(),void O(n)):I()},"^content.title.button$":function(e,t,n){X(n)},"^position.(my|at)$":function(e,t,n){"string"==typeof n&&(e[t]=new c.Corner(n))},"^position.container$":function(e,t,n){j.rendered&&R.appendTo(n)},"^show.ready$":function(){j.rendered?j.toggle(h):j.render(1)},"^style.classes$":function(e,t,n){R.attr("class",g+" qtip ui-helper-reset "+n)},"^style.widget|content.title":L,"^events.(render|show|move|hide|focus|blur)$":function(t,n,i){R[(e.isFunction(i)?"":"un")+"bind"]("tooltip"+n,i)},"^(show|hide|position).(event|target|fixed|inactive|leave|distance|viewport|adjust)":function(){var e=o.position;R.attr("tracking","mouse"===e.target&&e.adjust.mouse),C(),D()}},e.extend(j,{render:function(t){if(j.rendered)return j;var n=o.content.title.text,r=o.position,a=e.Event("tooltiprender");return e.attr(i[0],"aria-describedby",H),R=k.tooltip=e("<div/>",{id:H,"class":g+" qtip ui-helper-reset "+w+" "+o.style.classes,width:o.style.width||"",height:o.style.height||"",tracking:"mouse"===r.target&&r.adjust.mouse,role:"alert","aria-live":"polite","aria-describedby":H+"-content","aria-hidden":h}).toggleClass(m,N.disabled).data("qtip",j).appendTo(o.position.container).append(k.content=e("<div />",{"class":g+"-content",id:H+"-content"})),j.rendered=-1,_=1,z=1,n&&(Y(),O(n,d)),S(o.content.text,d),j.rendered=h,L(),e.each(o.events,function(t,n){e.isFunction(n)&&R.bind("toggle"===t?"tooltipshow tooltiphide":"tooltip"+t,n)}),e.each(c,function(){"render"===this.initialize&&this(j)}),D(),R.queue("fx",function(e){a.originalEvent=N.event,R.trigger(a,[j]),_=0,z=0,j.redraw(),(o.show.ready||t)&&j.toggle(h,N.event),e()}),j},get:function(e){var t,n;switch(e.toLowerCase()){case"dimensions":t={height:R.outerHeight(),width:R.outerWidth()};break;case"offset":t=c.offset(R,o.position.container);break;default:n=P(e.toLowerCase()),t=n[0][n[1]],t=t.precedance?t.string():t}return t},set:function(t,n){function i(e,t){var n,i,o;for(n in f)for(i in f[n])(o=new RegExp(i,"i").exec(e))&&(t.push(o),f[n][i].apply(j,t))}var a,s=/^position\.(my|at|adjust|target|container)|style|content|show\.ready/i,c=/^content\.(title|attr)|style/i,l=d,u=d,f=j.checks;return"string"==typeof t?(a=t,t={},t[a]=n):t=e.extend(h,{},t),e.each(t,function(n,i){var o,r=P(n.toLowerCase());o=r[0][r[1]],r[0][r[1]]="object"==typeof i&&i.nodeType?e(i):i,t[n]=[r[0],r[1],i,o],l=s.test(n)||l,u=c.test(n)||u}),r(o),z=_=1,e.each(t,i),z=_=0,R.is(":visible")&&j.rendered&&(l&&j.reposition("mouse"===o.position.target?p:N.event),u&&j.redraw()),j},toggle:function(t,n){function i(){t?(e.browser.msie&&R[0].style.removeAttribute("filter"),R.css("overflow",""),"string"==typeof c.autofocus&&e(c.autofocus,R).focus(),r=e.Event("tooltipvisible"),r.originalEvent=n?N.event:p,R.trigger(r,[j])):R.css({display:"",visibility:"",opacity:"",left:"",top:""})}if(!j.rendered){if(!t)return j;j.render(1)}var r,s=t?"show":"hide",c=o[s],f=R.is(":visible"),g=!n||o[s].target.length<2||N.target[0]===n.target,v=o.position,m=o.content;if((typeof t).search("boolean|number")&&(t=!f),!R.is(":animated")&&f===t&&g)return j;if(n){if(/over|enter/.test(n.type)&&/out|leave/.test(N.event.type)&&n.target===o.show.target[0]&&R.has(n.relatedTarget).length)return j;N.event=e.extend({},n)}return r=e.Event("tooltip"+s),r.originalEvent=n?N.event:p,R.trigger(r,[j,90]),r.isDefaultPrevented()?j:(e.attr(R[0],"aria-hidden",!t),t?(N.origin=e.extend({},l),j.focus(n),e.isFunction(m.text)&&S(m.text,d),e.isFunction(m.title.text)&&O(m.title.text,d),!u&&"mouse"===v.target&&v.adjust.mouse&&(e(document).bind("mousemove.qtip",function(e){l={pageX:e.pageX,pageY:e.pageY,type:"mousemove"}}),u=h),j.reposition(n),c.solo&&e(y,c.solo).not(R).qtip("hide",r)):(clearTimeout(j.timers.show),delete N.origin,u&&!e(y+'[tracking="true"]:visible',c.solo).not(R).length&&(e(document).unbind("mousemove.qtip"),u=d),j.blur(n)),g&&R.stop(0,1),c.effect===d?(R[s](),i.call(R)):e.isFunction(c.effect)?(c.effect.call(R,j),R.queue("fx",function(e){i(),e()})):R.fadeTo(90,t?1:0,i),t&&c.target.trigger("qtip-"+a+"-inactive"),j)},show:function(e){return j.toggle(h,e)},hide:function(e){return j.toggle(d,e)},focus:function(t){if(!j.rendered)return j;var n,i=e(y),o=parseInt(R[0].style.zIndex,10),r=s.zindex+i.length,a=e.extend({},t);return R.hasClass(b)||(n=e.Event("tooltipfocus"),n.originalEvent=a,R.trigger(n,[j,r]),n.isDefaultPrevented()||(o!==r&&(i.each(function(){this.style.zIndex>o&&(this.style.zIndex=this.style.zIndex-1)}),i.filter("."+b).qtip("blur",a)),R.addClass(b)[0].style.zIndex=r)),j},blur:function(t){var n,i=e.extend({},t);return R.removeClass(b),n=e.Event("tooltipblur"),n.originalEvent=i,R.trigger(n,[j]),j},reposition:function(n,i){if(!j.rendered||z)return j;z=1;var r=o.position.target,a=o.position,s=a.my,u=a.at,h=a.adjust,p=h.method.split(" "),f=R.outerWidth(),v=R.outerHeight(),m=0,y=0,w=e.Event("tooltipmove"),b="fixed"===R.css("position"),T=a.viewport,x={left:0,top:0},E=j.plugins.tip,M={horizontal:p[0],vertical:p[1]||p[0],left:function(e){var t="shift"===M.horizontal,n=T.offset.left+T.scrollLeft,i="left"===s.x?f:"right"===s.x?-f:-f/2,o="left"===u.x?m:"right"===u.x?-m:-m/2,r=E&&E.size?E.size.width||0:0,a=E&&E.corner&&"x"===E.corner.precedance&&!t?r:0,c=n-e+a,l=e+f-T.width-n+a,d=i-("x"===s.precedance||s.x===s.y?o:0),p="center"===s.x;return t?(a=E&&E.corner&&"y"===E.corner.precedance?r:0,d=("left"===s.x?1:-1)*i-a,x.left+=c>0?c:l>0?-l:0,x.left=Math.max(T.offset.left+(a&&"center"===E.corner.x?E.offset:0),e-d,Math.min(Math.max(T.offset.left+T.width,e+d),x.left))):(c>0&&("left"!==s.x||l>0)?x.left-=d+(p?0:2*h.x):l>0&&("right"!==s.x||c>0)&&(x.left-=p?-d:d+2*h.x),x.left!==e&&p&&(x.left-=h.x),x.left<n&&-x.left>l&&(x.left=e)),x.left-e},top:function(e){var t="shift"===M.vertical,n=T.offset.top+T.scrollTop,i="top"===s.y?v:"bottom"===s.y?-v:-v/2,o="top"===u.y?y:"bottom"===u.y?-y:-y/2,r=E&&E.size?E.size.height||0:0,a=E&&E.corner&&"y"===E.corner.precedance&&!t?r:0,c=n-e+a,l=e+v-T.height-n+a,d=i-("y"===s.precedance||s.x===s.y?o:0),p="center"===s.y;return t?(a=E&&E.corner&&"x"===E.corner.precedance?r:0,d=("top"===s.y?1:-1)*i-a,x.top+=c>0?c:l>0?-l:0,x.top=Math.max(T.offset.top+(a&&"center"===E.corner.x?E.offset:0),e-d,Math.min(Math.max(T.offset.top+T.height,e+d),x.top))):(c>0&&("top"!==s.y||l>0)?x.top-=d+(p?0:2*h.y):l>0&&("bottom"!==s.y||c>0)&&(x.top-=p?-d:d+2*h.y),x.top!==e&&p&&(x.top-=h.y),x.top<0&&-x.top>l&&(x.top=e)),x.top-e}};if(e.isArray(r)&&2===r.length)u={x:"left",y:"top"},x={left:r[0],top:r[1]};else if("mouse"===r&&(n&&n.pageX||N.event.pageX))u={x:"left",y:"top"},n=(!n||"resize"!==n.type&&"scroll"!==n.type?n&&n.pageX&&"mousemove"===n.type?n:!l||!l.pageX||!h.mouse&&n&&n.pageX?!h.mouse&&N.origin&&N.origin.pageX?N.origin:n:{pageX:l.pageX,pageY:l.pageY}:N.event)||n||N.event||l||{},x={top:n.pageY,left:n.pageX};else{if("event"===r?r=n&&n.target&&"scroll"!==n.type&&"resize"!==n.type?N.target=e(n.target):N.target:N.target=e(r),r=e(r).eq(0),0===r.length)return j;r[0]===document||r[0]===t?(m=c.iOS?t.innerWidth:r.width(),y=c.iOS?t.innerHeight:r.height(),r[0]===t&&(x={top:!b||c.iOS?(T||r).scrollTop():0,left:!b||c.iOS?(T||r).scrollLeft():0})):r.is("area")&&c.imagemap?x=c.imagemap(r,u):"http://www.w3.org/2000/svg"===r[0].namespaceURI&&c.svg?x=c.svg(r,u):(m=r.outerWidth(),y=r.outerHeight(),x=c.offset(r,a.container,b)),x.offset&&(m=x.width,y=x.height,x=x.offset),x.left+="right"===u.x?m:"center"===u.x?m/2:0,x.top+="bottom"===u.y?y:"center"===u.y?y/2:0}return x.left+=h.x+("right"===s.x?-f:"center"===s.x?-f/2:0),x.top+=h.y+("bottom"===s.y?-v:"center"===s.y?-v/2:0),T.jquery&&r[0]!==t&&r[0]!==q&&M.vertical+M.horizontal!=="nonenone"?(T={elem:T,height:T[(T[0]===t?"h":"outerH")+"eight"](),width:T[(T[0]===t?"w":"outerW")+"idth"](),scrollLeft:b?0:T.scrollLeft(),scrollTop:b?0:T.scrollTop(),offset:T.offset()||{left:0,top:0}},x.adjusted={left:"none"!==M.horizontal?M.left(x.left):0,top:"none"!==M.vertical?M.top(x.top):0}):x.adjusted={left:0,top:0},R.attr("class",function(){return e.attr(this,"class").replace(/ui-tooltip-pos-\w+/i,"")}).addClass(g+"-pos-"+s.abbreviation()),w.originalEvent=e.extend({},n),R.trigger(w,[j,x,T.elem||T]),w.isDefaultPrevented()?j:(delete x.adjusted,i===d||isNaN(x.left)||isNaN(x.top)||"mouse"===r||!e.isFunction(a.effect)?R.css(x):e.isFunction(a.effect)&&(a.effect.call(R,j,e.extend({},x)),R.queue(function(t){e(this).css({opacity:"",height:""}),e.browser.msie&&this.style.removeAttribute("filter"),t()})),z=0,j)},redraw:function(){if(j.rendered<1||_)return j;var e,t,n,i,r=o.position.container;return _=1,o.style.height&&R.css("height",o.style.height),o.style.width?R.css("width",o.style.width):(R.css("width","").addClass(x),t=R.width()+1,n=R.css("max-width")||"",i=R.css("min-width")||"",e=(n+i).indexOf("%")>-1?r.width()/100:0,n=(n.indexOf("%")>-1?e:1)*parseInt(n,10)||t,i=(i.indexOf("%")>-1?e:1)*parseInt(i,10)||0,t=n+i?Math.min(Math.max(t,i),n):t,R.css("width",Math.round(t)).removeClass(x)),_=0,j},disable:function(t){return"boolean"!=typeof t&&(t=!R.hasClass(m)&&!N.disabled),j.rendered?(R.toggleClass(m,t),e.attr(R[0],"aria-disabled",t)):N.disabled=!!t,j},enable:function(){return j.disable(d)},destroy:function(){var t=i[0],n=e.attr(t,M);return j.rendered&&(R.remove(),e.each(j.plugins,function(){this.destroy&&this.destroy()})),clearTimeout(j.timers.show),clearTimeout(j.timers.hide),C(),e.removeData(t,"qtip"),o.suppress&&n&&(e.attr(t,"title",n),i.removeAttr(M)),i.removeAttr("aria-describedby").unbind(".qtip"),delete f[j.id],i}})}function r(t){var n;return t&&"object"==typeof t?("object"!=typeof t.metadata&&(t.metadata={type:t.metadata}),"content"in t&&(("object"!=typeof t.content||t.content.jquery)&&(t.content={text:t.content}),n=t.content.text||d,!e.isFunction(n)&&(!n&&!n.attr||n.length<1||"object"==typeof n&&!n.jquery)&&(t.content.text=d),"title"in t.content&&("object"!=typeof t.content.title&&(t.content.title={text:t.content.title}),n=t.content.title.text||d,!e.isFunction(n)&&(!n&&!n.attr||n.length<1||"object"==typeof n&&!n.jquery)&&(t.content.title.text=d))),"position"in t&&"object"!=typeof t.position&&(t.position={my:t.position,at:t.position}),"show"in t&&"object"!=typeof t.show&&(t.show=t.show.jquery?{target:t.show}:{event:t.show}),"hide"in t&&"object"!=typeof t.hide&&(t.hide=t.hide.jquery?{target:t.hide}:{event:t.hide}),"style"in t&&"object"!=typeof t.style&&(t.style={classes:t.style}),e.each(c,function(){this.sanitize&&this.sanitize(t)}),t):d}function a(){if(a.history=a.history||[],a.history.push(arguments),"object"==typeof console){var e,t=console[console.warn?"warn":"log"],n=Array.prototype.slice.call(arguments);"string"==typeof arguments[0]&&(n[0]="qTip2: "+n[0]),e=t.apply?t.apply(console,n):t(n)}}var s,c,l,u,h=!0,d=!1,p=null,f={},g="ui-tooltip",v="ui-widget",m="ui-state-disabled",y="div.qtip."+g,w=g+"-default",b=g+"-focus",T=g+"-hover",x=g+"-fluid",E="_replacedByqTip",M="oldtitle";s=e.fn.qtip=function(t,i,o){var a=(""+t).toLowerCase(),c=p,l="disable"===a?[h]:e.makeArray(arguments).slice(1),u=l[l.length-1],f=this[0]?e.data(this[0],"qtip"):p;return!arguments.length&&f||"api"===a?f:"string"==typeof t?(this.each(function(){var t=e.data(this,"qtip");if(!t)return h;if(u&&u.timeStamp&&(t.cache.event=u),"option"!==a&&"options"!==a||!i)t[a]&&t[a].apply(t[a],l);else{if(!e.isPlainObject(i)&&o===n)return c=t.get(i),d;t.set(i,o)}}),c!==p?c:this):"object"!=typeof t&&arguments.length?void 0:(f=r(e.extend(h,{},t)),s.bind.call(this,f,u))},s.bind=function(t,o){return this.each(function(r){function a(t){function i(){m.render("object"==typeof t||u.show.ready),p.show.add(p.hide).unbind(v)}return m.cache.disabled?d:(m.cache.event=e.extend({},t),m.cache.target=t?e(t.target):[n],u.show.delay>0?(clearTimeout(m.timers.show),m.timers.show=setTimeout(i,u.show.delay),g.show!==g.hide&&p.hide.bind(g.hide,function(){clearTimeout(m.timers.show)})):i(),void 0)}var u,p,g,v,m,y;return y=e.isArray(t.id)?t.id[r]:t.id,y=!y||y===d||y.length<1||f[y]?s.nextid++:f[y]=y,v=".qtip-"+y+"-create",m=i.call(this,y,t),m===d?h:(u=m.options,e.each(c,function(){"initialize"===this.initialize&&this(m)}),p={show:u.show.target,hide:u.hide.target},g={show:e.trim(""+u.show.event).replace(/ /g,v+" ")+v,hide:e.trim(""+u.hide.event).replace(/ /g,v+" ")+v},/mouse(over|enter)/i.test(g.show)&&!/mouse(out|leave)/i.test(g.hide)&&(g.hide+=" mouseleave"+v),p.show.bind("mousemove"+v,function(e){l={pageX:e.pageX,pageY:e.pageY,type:"mousemove"}}),p.show.bind(g.show,a),(u.show.ready||u.prerender)&&a(o),void 0)})},c=s.plugins={Corner:function(e){e=(""+e).replace(/([A-Z])/," $1").replace(/middle/gi,"center").toLowerCase(),this.x=(e.match(/left|right/i)||e.match(/center/)||["inherit"])[0].toLowerCase(),this.y=(e.match(/top|bottom|center/i)||["inherit"])[0].toLowerCase(),this.precedance=e.charAt(0).search(/^(t|b)/)>-1?"y":"x",this.string=function(){return"y"===this.precedance?this.y+this.x:this.x+this.y},this.abbreviation=function(){var e=this.x.substr(0,1),t=this.y.substr(0,1);return e===t?e:"c"===e||"c"!==e&&"c"!==t?t+e:e+t}},offset:function(n,i,o){function r(e,t){s.left+=t*e.scrollLeft(),s.top+=t*e.scrollTop()}var a,s=n.offset(),l=i,u=0,h=document.body;if(l){do if("static"!==l.css("position")&&(a=l[0]===h?{left:parseInt(l.css("left"),10)||0,top:parseInt(l.css("top"),10)||0}:l.position(),s.left-=a.left+(parseInt(l.css("borderLeftWidth"),10)||0)+(parseInt(l.css("marginLeft"),10)||0),s.top-=a.top+(parseInt(l.css("borderTopWidth"),10)||0),u++),l[0]===h)break;while(l=l.offsetParent());i[0]!==h&&u>1&&r(i,1),(c.iOS<4.1&&c.iOS>3.1||!c.iOS&&o)&&r(e(t),-1)}return s},iOS:parseFloat((""+(/CPU.*OS ([0-9_]{1,3})|(CPU like).*AppleWebKit.*Mobile/i.exec(navigator.userAgent)||[0,""])[1]).replace("undefined","3_2").replace("_","."))||d,fn:{attr:function(t,n){if(this.length){var i=this[0],o="title",r=e.data(i,"qtip");if(t===o&&"object"==typeof r&&r.options.suppress)return arguments.length<2?e.attr(i,M):(r&&r.options.content.attr===o&&r.cache.attr&&r.set("content.text",n),this.attr(M,n))}return e.fn["attr"+E].apply(this,arguments)},clone:function(t){var n=(e([]),e.fn["clone"+E].apply(this,arguments));return t||n.filter("["+M+"]").attr("title",function(){return e.attr(this,M)}).removeAttr(M),n},remove:e.ui?p:function(t,n){e(this).each(function(){n||(!t||e.filter(t,[this]).length)&&e("*",this).add(this).each(function(){e(this).triggerHandler("remove")})})}}},e.each(c.fn,function(t,n){if(!n)return h;var i=e.fn[t+E]=e.fn[t];e.fn[t]=function(){return n.apply(this,arguments)||i.apply(this,arguments)}}),s.version="nightly",s.nextid=0,s.inactiveEvents="click dblclick mousedown mouseup mousemove mouseleave mouseenter".split(" "),s.zindex=15e3,s.defaults={prerender:d,id:d,overwrite:h,suppress:h,content:{text:h,attr:"title",title:{text:d,button:d}},position:{my:"top left",at:"bottom right",target:d,container:d,viewport:d,adjust:{x:0,y:0,mouse:h,resize:h,method:"flip flip"},effect:function(t,n){e(this).animate(n,{duration:200,queue:d})}},show:{target:d,event:"mouseenter",effect:h,delay:90,solo:d,ready:d,autofocus:d},hide:{target:d,event:"mouseleave",effect:h,delay:0,fixed:d,inactive:d,leave:"window",distance:d},style:{classes:"",widget:d,width:d,height:d},events:{render:p,move:p,show:p,hide:p,toggle:p,visible:p,focus:p,blur:p}}}(jQuery,window),/*!*
* Get mouse coordinate.
* @copyright 2016 Ortery Inc.
* @author Sam Wang
* @param {event} which event fires up.
* @return {array} x, y position.
*/
function(e,t){"use strict";e.getCoordinates=function(e){var n,i;return-1===e.type.search("mouse")&&-1===e.type.search("point")?e.touches&&e.touches.length?(n=e.touches[0].pageX,i=e.touches[0].pageY):e.changedTouches&&e.changedTouches.length&&(n=e.changedTouches[0].pageX,i=e.changedTouches[0].pageY):e.pageX||e.pageY?(n=e.pageX,i=e.pageY):(e.clientX||e.clientY)&&(n=e.clientX+t.body.scrollLeft+t.documentElement.scrollLeft,i=e.clientY+t.body.scrollTop+t.documentElement.scrollTop),[n,i]}}(jQuery,document),/*!
* Check all images are loaded into array.
* If it is done, continue other actions, else examines again.
* @copyright 2016 Ortery Inc.
* @name getSizeToFitContainer
* @function
* @param {Array} The outer container size.
* @param {Array} The size of div which is placed into outer container).
* @param {Boolean} Allow enlarge image size exceed its original size or not.
* @return {Array} Suitable size.
*/
function(e){e.getSizeToFitContainer=function(e,t,n){var i,o,r,a,s,c;return i=e[0],o=e[1],r=t[0]/t[1],a=i/o,a>=1?r>=1&&r>a?(s=i,c=s/r):(c=o,s=c*r):1>=r&&a>r?(c=o,s=c*r):(s=i,c=s/r),!n&&(s>t[0]||c>t[1])?t:[~~s,~~c]}}(jQuery),function(e){var t,n,i;i=function(e){e=e.toLowerCase();var t=/(chrome)[ \/]([\w.]+)/.exec(e)||/(webkit)[ \/]([\w.]+)/.exec(e)||/(opera)(?:.*version|)[ \/]([\w.]+)/.exec(e)||/(msie) ([\w.]+)/.exec(e)||e.indexOf("compatible")<0&&/(mozilla)(?:.*? rv:([\w.]+)|)/.exec(e)||[];return{browser:t[1]||"",version:t[2]||"0"}},t=i(navigator.userAgent),n={},t.browser&&(n[t.browser]=!0,n.version=t.version),n.chrome?n.webkit=!0:n.webkit&&(n.safari=!0),e.browser=n}(jQuery);